/**
 * @file impedance_measurement_mode.hpp
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief Impedance measurement mode constants
 * 
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#include "impedance_measurement_mode.h"

namespace brainaccess::core
{
	enum class impedance_measurement_mode : ba_impedance_measurement_mode
	{
		OFF = BA_IMPEDANCE_MEASUREMENT_MODE_OFF,         ///< No active impedance measurement
		HZ_7_8 = BA_IMPEDANCE_MEASUREMENT_MODE_HZ_7_8,   ///< 7.8 Hz wave
		HZ_31_2 = BA_IMPEDANCE_MEASUREMENT_MODE_HZ_31_2, ///< 31.2 Hz wave
		DR_DIV4 = BA_IMPEDANCE_MEASUREMENT_MODE_DR_DIV4  ///< Wave frequency of sample_rate/4
	};
}
