/**
 * @file full_battery_info.h
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief Full battery info
 * 
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#ifndef __cplusplus
    #include <stdbool.h>
#endif //__cplusplus

#include <stdint.h>

/**
 * @brief Struct containing extended battery information received from the
 * device
 */
typedef struct
{
	bool is_charging;          ///< True if battery is charging
	bool is_charger_connected; ///< True if charger is connected to the device
	uint8_t level;             ///< Battery charge percentage, 0-100
	float health;              ///< Battery health percentage, 0-100
	float voltage;             ///< Battery voltage in volts
	float current;             ///< Current flow in amps (negative means discharge)
} ba_full_battery_info;
