/**
 * @file device_model.hpp
 * @author Neurotechnology (brainaccess@neurotechnology.com)
 * @brief BrainAccess device model numbers
 *
 * @copyright Copyright (c) 2022 Neurotechnology
 */

#pragma once

#include "device_model.h"

namespace brainaccess::core
{
	enum class device_model : ba_device_model
	{
		MINI_V2 = BA_DEVICE_MODEL_MINI_V2, ///< BrainAccess MINI V2
		MIDI = BA_DEVICE_MODEL_MIDI, ///< BrainAccess MIDI (16 Channels)
		MAXI = BA_DEVICE_MODEL_MAXI, ///< BrainAccess MAXI (32 Channels)
		EMG = BA_DEVICE_MODEL_EMG, ///< BrainAccess EMG
		HALO = BA_DEVICE_MODEL_HALO, ///< BrainAccess Halo
		UNKNOWN = BA_DEVICE_MODEL_UNKNOWN  ///< Unknown device
	};
}
